<?php

namespace App\Models\Accreditation;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Accreditation extends Model 
{

    protected $table = 'accreditations';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function getActionFacts()
    {
        return $this->belongsTo('Events');
    }

    public function getChallenge()
    {
        return $this->belongsTo('Challenge');
    }

    public function getQuiz()
    {
        return $this->belongsTo('Quiz');
    }

}